/* 
------------------------------------------------------------------------------------------------------------------------------

   Auteur :   A4 Technologie
   Date :     06/02/2015
   Fichier :  Barriere_sequence_7.INO
   Document : Dossier barrière de parking (D-APARK)
   Objectif : Compter le nombre de places disponible et l'afficher sur l'écran OLED
  
------------------------------------------------------------------------------------------------------------------------------

Connexion de l’interface AutoProgUno (Arduino) à la maquette :

  Module capteur	Variable Arduino	Broche AutoProg Uno

Bouton poussoir/RFID       bouton_poussoir                A4
Récepteur infrarouge	   recepteur_IR                   A5
Fin de course fermeture	   fdc_fermeture	          3
Fin de course ouverture	   fdc_ouverture	          2


Module actionneur	Variable Arduino	Broche AutoProg Uno

Module Gyrophare	    gyrophare	                  4
Emetteur infrarouge	    emetteur_IR                   5
Moteur                        moteur                      6
LCD                            OLED                       7
ouverture/fermeture		

------------------------------------------------------------------------------------------------------------------------------
*/
//Bibliothèque
#include <IRremote.h>//La bibliothèque doit être copié dans le dossier librairies du logiciel Arduino
#include <AXE133Y.h>//bibliothèque OLED

//Définition des variables, constantes et pin :

byte nb_place = 10; // Initialisation de 10 places dans le parking
// Pin d'entrées

const int fdc_fermeture   = 3; 
const int fdc_ouverture   = 2; 
const int bouton_poussoir = A4;
const int recepteur_IR    = A5;


//Pin de sorties
const int gyrophare     = 4; 
const int emetteur_IR   = 5; 
const int moteur        = 6; 
const int oled          = 7;

AXE133Y OLED = AXE133Y(oled);//Affectation du pin de l'écran OLED

//Initialisation

void setup()
{
    //paramètrage des pins en entrée/sortie
    
    // Définition des pins comme des entrées

    pinMode (fdc_fermeture, INPUT);
    pinMode (fdc_ouverture, INPUT);
    pinMode (bouton_poussoir, INPUT);
    pinMode (recepteur_IR, INPUT);
   
    // Définition des pins comme des sorties
    pinMode (gyrophare, OUTPUT);
    pinMode (emetteur_IR, OUTPUT);
    pinMode (moteur, OUTPUT);
    
    OLED.cursorPosition(1,0);//Initialisation du texte du Parking
    OLED.print("Parking Ouvert");
    OLED.cursorPosition(2,0);
    OLED.print("A4 Technologie");    
    
    
    
    
}



//Programme principal

//Boucle infinie
void loop()
{
 
 digitalWrite(emetteur_IR,HIGH); // Activation de la barrière infrarouge
 
  if (nb_place>0)
  {
   if (digitalRead(recepteur_IR)==HIGH && digitalRead(bouton_poussoir)==HIGH )   //Si le code reçu par le récepteur infrarouge est 6
   {      
     ouverture_barriere();//Aller dans la fonction ouverture_barriere
  
     delay(3000); // Attendre 3 secondes   
     
     nb_place=nb_place-1;
     OLED.clearScreen();
     OLED.cursorPosition(1,0);//Initialisation du texte du Parking
     OLED.print("Parking Ouvert");
     OLED.cursorPosition(2,0);
     OLED.print(String(nb_place));
     OLED.print(" places");   
     
     fermeture_barriere(); //Aller dans la fonction fermeture_barriere  
   }
  }
  
  else
  {
      OLED.cursorPosition(1,0);//Initialisation du texte du Parking
      OLED.print("Parking Plein");
      OLED.cursorPosition(2,0);
      OLED.print(""); 
  }    
}
// Fin du Programme principal

// Fonctions

void ouverture_barriere()// Fonction ouverture de la barriere
{
       while (digitalRead(fdc_ouverture)==LOW)// exécuter les commandes tant que fdc_ouverture est désactivé  
     {
       digitalWrite(moteur,HIGH);// Marche du moteur (ouverture de la barrière
       digitalWrite(gyrophare,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare,LOW);// Désactivation du gyrophare
       delay(100);       
     }
     digitalWrite(moteur,LOW); // Arrêt du moteur
}     

void fermeture_barriere()// Fonction fermeture de la barriere
{
       while (digitalRead(fdc_fermeture)==LOW) // exécuter les commandes tant que fdc_fermeture est désactivé 
     {
         while (digitalRead(recepteur_IR)==HIGH)// Tant que la détection infrarouge est activée
         {
           digitalWrite(moteur,LOW); // Arrêt du moteur
           delay (500);
         }     
       digitalWrite(moteur,HIGH); // Marche du moteur (fermeture de la barrière)
       digitalWrite(gyrophare,HIGH);// Activation du gyrophare
       delay(100);
       digitalWrite(gyrophare,LOW);// Désactivation du gyrophare
       delay(100);     
      
     }
        digitalWrite(moteur,LOW); // Arrêt du moteur
}     
